/* 
 * File:   7seg.h
 * Author: User
 *
 * Created on 24 November 2015, 1:02 PM
 */

#ifndef _7SEG_H
#define	_7SEG_H

#ifdef	__cplusplus
extern "C" {
#endif


#define SEGA (1<<11)
#define SEGB (1<<12)
#define SEGC (1<<14)
#define SEGD (1<<10)
#define SEGE (1<<9)
#define SEGF (1<<8)
#define SEGG (1<<7)
#define DP   (1<<3)
#define DIGMASK (SEGA|SEGB|SEGC|SEGD|SEGE|SEGF|SEGG|DP)

#define FIRST_DIGIT '-'
#define LAST_DIGIT  '^'
#define INDIVIDUAL_SEG_OFFSET (LAST_DIGIT+1)

extern volatile char display[6];
extern volatile unsigned char colons, dps, dim_dps;
extern int brightness;

typedef void (*delay_func) ();

__attribute__((mips16)) void setup_7seg_IOs();
__attribute__((mips16)) void teardown_7seg_IOs();
__attribute__((mips16)) void setup_7seg_TMR();
__attribute__((mips16)) void teardown_7seg_TMR();
__attribute__((mips16)) void display_test(delay_func pdelay_func);

#ifdef	__cplusplus
}
#endif

#endif	/* _7SEG_H */

